require('dotenv').config();

const prisma = require('../src/prisma');
const { hashPassword } = require('../src/utils/crypto');

async function run() {
  const [emailArg, passwordArg] = process.argv.slice(2);
  const email = emailArg || process.env.ADMIN_EMAIL;
  const password = passwordArg || process.env.ADMIN_PASSWORD;

  if (!email || !password) {
    console.error('Usage: node scripts/create-admin.js <email> <password>');
    console.error('Or set ADMIN_EMAIL and ADMIN_PASSWORD in backend/.env');
    process.exit(1);
  }

  const passwordHash = await hashPassword(password);
  const admin = await prisma.adminUser.upsert({
    where: { email },
    update: { passwordHash },
    create: { email, passwordHash, role: 'ADMIN' },
  });

  console.log(`Admin ready: ${admin.email}`);
}

run()
  .catch((err) => {
    console.error('Failed to create admin:', err);
    process.exit(1);
  })
  .finally(async () => {
    await prisma.$disconnect();
  });
