const { z } = require('zod');
const { updateUser, updatePassword } = require('../services/userService');

const updateSchema = z.object({
  name: z.string().min(2).optional(),
  email: z.string().email().optional(),
  phone: z.string().optional(),
});

const passwordSchema = z.object({
  currentPassword: z.string().min(6),
  newPassword: z.string().min(6),
});

async function getProfile(req, res) {
  const user = req.user;
  res.json({
    id: user.id,
    name: user.name,
    email: user.email,
    phone: user.phone,
    balance: user.wallet?.balance || 0,
  });
}

async function updateProfile(req, res, next) {
  try {
    const payload = updateSchema.parse(req.body);
    const user = await updateUser(req.user.id, payload);
    res.json({
      id: user.id,
      name: user.name,
      email: user.email,
      phone: user.phone,
    });
  } catch (err) {
    next(err);
  }
}

async function changePassword(req, res, next) {
  try {
    const payload = passwordSchema.parse(req.body);
    await updatePassword(req.user.id, payload.currentPassword, payload.newPassword);
    res.json({ message: 'Password updated' });
  } catch (err) {
    next(err);
  }
}

module.exports = {
  getProfile,
  updateProfile,
  changePassword,
};
