const { z } = require('zod');
const orderService = require('../services/orderService');

const orderSchema = z.object({
  game_code: z.string().min(1),
  product_code: z.string().min(1),
  payment_method: z.enum(['WALLET', 'QRIS', 'EWALLET']),
  inputs: z.record(z.any()),
});

async function create(req, res, next) {
  try {
    const payload = orderSchema.parse(req.body);
    const result = await orderService.createOrder({
      user: req.user,
      gameCode: payload.game_code,
      productCode: payload.product_code,
      inputs: payload.inputs || {},
      paymentMethod: payload.payment_method,
    });
    res.json(result);
  } catch (err) {
    next(err);
  }
}

async function list(req, res, next) {
  try {
    const orders = await orderService.listOrders(req.user.id);
    res.json({ data: orders });
  } catch (err) {
    next(err);
  }
}

module.exports = {
  create,
  list,
};
