const prisma = require('../prisma');

async function balance(req, res, next) {
  try {
    const wallet = await prisma.wallet.findUnique({ where: { userId: req.user.id } });
    res.json({ balance: wallet?.balance || 0 });
  } catch (err) {
    next(err);
  }
}

async function transactions(req, res, next) {
  try {
    const list = await prisma.walletTransaction.findMany({
      where: { userId: req.user.id },
      orderBy: { createdAt: 'desc' },
    });
    res.json({ data: list });
  } catch (err) {
    next(err);
  }
}

module.exports = {
  balance,
  transactions,
};
