const { verifyToken } = require('../utils/jwt');
const prisma = require('../prisma');
const { createError } = require('../utils/errors');

async function requireAuth(req, res, next) {
  try {
    const header = req.headers.authorization || '';
    const token = header.startsWith('Bearer ') ? header.slice(7) : null;
    if (!token) {
      throw createError(401, 'Unauthorized');
    }
    const payload = verifyToken(token);
    const user = await prisma.user.findUnique({
      where: { id: payload.sub },
      include: { wallet: true },
    });
    if (!user) {
      throw createError(401, 'Unauthorized');
    }
    req.user = user;
    next();
  } catch (err) {
    next(err.status ? err : createError(401, 'Unauthorized'));
  }
}

function requireAdmin(req, res, next) {
  if (!req.user || req.user.role !== 'ADMIN') {
    return next(createError(403, 'Forbidden'));
  }
  return next();
}

module.exports = { requireAuth, requireAdmin };
