const router = require('express').Router();
const adminController = require('../controllers/adminController');
const { requireAdminAuth } = require('../middleware/adminAuth');

router.post('/login', adminController.login);
router.get('/settings', requireAdminAuth, adminController.getSettingsHandler);
router.put('/settings', requireAdminAuth, adminController.updateSettingsHandler);
router.post('/games/sync', requireAdminAuth, adminController.syncGamesHandler);
router.get('/games', requireAdminAuth, adminController.listGamesHandler);
router.patch('/games/:code', requireAdminAuth, adminController.updateGameStatusHandler);
router.get('/transactions', requireAdminAuth, adminController.listTransactionsHandler);
router.get('/reports/profit', requireAdminAuth, adminController.profitReportHandler);
router.get('/site', requireAdminAuth, adminController.getSiteSettingsHandler);
router.put('/site', requireAdminAuth, adminController.updateSiteSettingsHandler);

module.exports = router;
