const router = require('express').Router();
const { requireAuth } = require('../middleware/auth');
const paymentsController = require('../controllers/paymentsController');

router.post('/deposit', requireAuth, paymentsController.createDeposit);
router.get('/:paymentId/status', paymentsController.checkStatus);
router.post('/:paymentId/cancel', paymentsController.cancel);

module.exports = router;
