const apigamesService = require('./apigamesService');

function extractArray(payload) {
  if (Array.isArray(payload)) return payload;
  if (payload && Array.isArray(payload.data)) return payload.data;
  if (payload && Array.isArray(payload.products)) return payload.products;
  return [];
}

function normalizeProduct(item) {
  return {
    code: item.product_code || item.code || item.kode || item.sku || item.id,
    name: item.product_name || item.name || item.nama || item.title,
    price: item.price_rp || item.price || item.harga || item.price_api || item.price_api_rp,
    iconUrl: item.icon_url || item.icon || item.image || item.img || null,
    raw: item,
  };
}

async function listProducts(gameCode) {
  const payload = await apigamesService.listProductsByGame(gameCode);
  const list = extractArray(payload).map(normalizeProduct);
  return list.filter((item) => item.code && item.name);
}

module.exports = {
  listProducts,
  normalizeProduct,
};
