const prisma = require('../prisma');

async function ensureSettings() {
  const existing = await prisma.settings.findUnique({ where: { id: 1 } });
  if (!existing) {
    await prisma.settings.create({
      data: {
        id: 1,
        productMarginPercent: 0,
        depositFeePercent: 0,
        siteName: 'Menvora',
        siteDescription: 'Platform top up game cepat, aman, dan otomatis.',
        siteKeywords: 'topup game, voucher game, isi ulang, pulsa, ewallet, tagihan',
        footerText: '© Menvora. All rights reserved.',
        maintenanceMode: 'none',
      },
    });
  }
}

async function getSettings() {
  await ensureSettings();
  return prisma.settings.findUnique({ where: { id: 1 } });
}

async function updateSettings(data) {
  await ensureSettings();
  return prisma.settings.update({
    where: { id: 1 },
    data: {
      productMarginPercent: data.productMarginPercent,
      depositFeePercent: data.depositFeePercent,
    },
  });
}

async function updateSiteSettings(data) {
  await ensureSettings();
  return prisma.settings.update({
    where: { id: 1 },
    data,
  });
}

async function getPublicSettings() {
  const settings = await getSettings();
  return {
    site_name: settings.siteName || 'Menvora',
    site_description: settings.siteDescription || '',
    site_keywords: settings.siteKeywords || '',
    site_logo_url: settings.siteLogoUrl || '',
    site_favicon_url: settings.siteFaviconUrl || '',
    site_og_image_url: settings.siteOgImageUrl || '',
    cs_link: settings.csLink || '',
    footer_text: settings.footerText || '',
    maintenance_mode: settings.maintenanceMode || 'none',
  };
}

module.exports = {
  ensureSettings,
  getSettings,
  updateSettings,
  updateSiteSettings,
  getPublicSettings,
};
