(async function () {
  try {
    const token = getToken();
    if (!token) {
      window.location.href = 'login.html';
      return;
    }

    const profile = await apiFetch('/api/me');

    const goSettings = () => {
      window.location.href = 'settings.html';
    };

    const nameEl = document.getElementById('namaUserDisplay');
    if (nameEl) {
      nameEl.textContent = `Hi, ${profile.name}`;
      nameEl.style.cursor = 'pointer';
      nameEl.addEventListener('click', goSettings);
    }

    const profilEl = document.querySelector('.profil');
    if (profilEl) {
      profilEl.style.cursor = 'pointer';
      profilEl.addEventListener('click', (event) => {
        if (event.target && event.target.closest && event.target.closest('[onclick]')) {
          return;
        }
        goSettings();
      });
    }

    const saldoEl = document.getElementById('rumahhtmlsaldo');
    if (saldoEl) {
      saldoEl.textContent = formatRupiah(profile.balance || 0);
    }

    const poinEl = document.getElementById('rumahhtmlpoin');
    if (poinEl) {
      poinEl.textContent = '0';
    }

    const refreshLink = document.getElementById('refreshSaldo');
    if (refreshLink && saldoEl) {
      refreshLink.addEventListener('click', async (event) => {
        event.preventDefault();
        try {
          const wallet = await apiFetch('/api/wallet/balance');
          saldoEl.textContent = formatRupiah(wallet.balance || 0);
        } catch (err) {
          alert(err.message || 'Gagal memuat saldo.');
        }
      });
    }

    async function startDepositFlow(method = 'QRIS') {
      const amount = await requestAmount({
        title: 'Masukkan nominal deposit',
        hint: 'Nominal dalam angka saja',
        confirmText: 'Lanjutkan',
      });
      if (!amount) return;
      try {
        const payment = await apiFetch('/api/payments/deposit', {
          method: 'POST',
          body: JSON.stringify({ amount, method }),
        });
        const storageKey = `menvora_payment_${payment.payment_id}`;
        localStorage.setItem(storageKey, JSON.stringify(payment));
        window.location.href = `deposit.html?payment_id=${encodeURIComponent(payment.payment_id)}&method=${encodeURIComponent(method)}`;
      } catch (err) {
        alert(err.message || 'Gagal membuat pembayaran.');
      }
    }

    const depositLinks = document.querySelectorAll('a[href="deposit.html"]');
    if (depositLinks.length) {
      depositLinks.forEach((link) => {
        link.addEventListener('click', (event) => {
          event.preventDefault();
          startDepositFlow('QRIS');
        });
      });
    }

    const panelLinks = document.querySelectorAll('.link-panel');
    if (panelLinks.length) {
      panelLinks.forEach((link) => {
        if (link.textContent.includes('Top Up')) {
          link.setAttribute('href', 'game_list.html');
        }
      });
    }

    const teksPDisplay = document.getElementById('teksPDisplay');
    if (teksPDisplay) {
      teksPDisplay.innerHTML = `
        <a href="game_list.html" class="link-bottom-panel">
          <img src="https://telegra.ph/file/8e1f998e12082ae39ed53.jpg" alt="game" class="icon-bottom-panel" />
          Game
        </a>
      `;
    }

    const csBubble = document.querySelector('.cs-bubble');
    if (csBubble) {
      const runtimeCs = window.__SITE_CONFIG__?.cs_link;
      const link = (runtimeCs || CS_LINK || '').trim();
      if (link) {
        csBubble.setAttribute('href', link);
      }
    }

    const fallbackIcon = 'assets/icons/placeholder.svg';
    document.querySelectorAll('img.icon-panel, img.icon-bottom-panel, #iconImg').forEach((img) => {
      img.addEventListener('error', () => {
        if (img.dataset.fallbackApplied) return;
        img.dataset.fallbackApplied = '1';
        img.src = fallbackIcon;
      });
    });
  } catch (err) {
    clearToken();
    window.location.href = 'login.html';
  }
})();

function toggleBlur() {
  const blurredText = document.getElementById('rumahhtmlsaldo');
  if (!blurredText) return;
  blurredText.classList.toggle('blur');
  const icon1 = document.getElementById('icon1');
  const icon2 = document.getElementById('icon2');
  if (icon1 && icon2) {
    icon1.classList.toggle('hidden');
    icon2.classList.toggle('hidden');
  }
}

window.openCity = function openCity(evt, cityName) {
  const tabcontent = document.getElementsByClassName('city');
  for (let i = 0; i < tabcontent.length; i += 1) {
    tabcontent[i].style.display = 'none';
  }
  const tablinks = document.getElementsByClassName('tablink');
  for (let i = 0; i < tablinks.length; i += 1) {
    tablinks[i].className = tablinks[i].className.replace(' w3-red', '');
  }
  const current = document.getElementById(cityName);
  if (current) current.style.display = 'block';
  if (evt && evt.currentTarget) {
    evt.currentTarget.className += ' w3-red';
  }
};

document.addEventListener('DOMContentLoaded', () => {
  const activeTab = document.querySelector('.tablink.w3-red') || document.querySelector('.tablink');
  if (!activeTab) return;
  const onclick = activeTab.getAttribute('onclick') || '';
  const match = onclick.match(/openCity\\(event,\\s*'([^']+)'\\)/);
  if (match && match[1]) {
    window.openCity({ currentTarget: activeTab }, match[1]);
  }
});
