(function () {
  const token = getToken();
  if (!token) {
    window.location.href = 'login.html';
    return;
  }
  const params = new URLSearchParams(window.location.search);
  const paymentId = params.get('payment_id');
  const method = params.get('method') || 'QRIS';
  if (!paymentId) return;

  const storageKey = `menvora_payment_${paymentId}`;
  const paymentData = JSON.parse(localStorage.getItem(storageKey) || '{}');

  const amount = paymentData.amount || 0;
  const fee = paymentData.fee || 0;
  const total = paymentData.total || 0;
  const isOrder = paymentData.type === 'ORDER';

  const val1 = document.getElementById('val-1');
  const val2 = document.getElementById('val-2');
  const val3 = document.getElementById('val-3');
  const val5 = document.getElementById('val-5');
  const totalInput = document.getElementById('total-bayar');

  if (val1) val1.textContent = formatRupiah(amount);
  if (val2) val2.textContent = formatRupiah(0);
  if (val3) val3.textContent = formatRupiah(fee);
  if (val5) val5.textContent = formatRupiah(total);
  if (totalInput) totalInput.value = total ? total.toString() : '';

  const methodLabel = method === 'EWALLET' ? 'E-Wallet' : 'QRIS';
  const placeholders = {
    '{{nama_aplikasi}}': methodLabel,
    '{{jenis_payment}}': methodLabel,
    '{{id_transaksi}}': paymentId,
    '{{jumlah_topup}}': formatRupiah(amount),
    '{{kode_unik}}': formatRupiah(0),
    '{{biaya_admin}}': formatRupiah(fee),
    '{{total_bayar}}': formatRupiah(total),
  };

  function replacePlaceholder(needle, value) {
    document.querySelectorAll('*').forEach((el) => {
      if (el.childElementCount > 0) return;
      if (!el.textContent || !el.textContent.includes(needle)) return;
      el.textContent = el.textContent.replace(needle, value);
    });
  }

  Object.entries(placeholders).forEach(([key, value]) => replacePlaceholder(key, value));

  if (isOrder) {
    document.querySelectorAll('*').forEach((el) => {
      if (el.childElementCount > 0) return;
      if (!el.textContent) return;
      if (el.textContent.includes('Batalkan Deposit')) {
        el.textContent = el.textContent.replace('Batalkan Deposit', 'Batalkan Pembayaran');
      }
      if (el.textContent.includes('Deposit')) {
        el.textContent = el.textContent.replace('Deposit', 'Pembayaran');
      }
    });
  }

  const expEl = document.getElementById('exp');
  const expiredAtRaw = paymentData?.meta?.expiredAt;
  const expiredAt = expiredAtRaw ? new Date(expiredAtRaw).getTime() : Date.now() + 15 * 60 * 1000;

  const alertOverlay = document.getElementById('alertzo');
  const statusBox = document.getElementById('statusPembayaran');

  let cancelBtn = null;
  if (statusBox) {
    cancelBtn = document.createElement('div');
    cancelBtn.id = 'cancelDepositBtn';
    cancelBtn.className = 'btn-konfirm bg-pink';
    cancelBtn.style.marginTop = '8px';
    cancelBtn.textContent = isOrder ? 'Batalkan Pembayaran' : 'Batalkan Deposit';
    statusBox.insertAdjacentElement('afterend', cancelBtn);
  }

  const qrContainer = document.getElementById('qrcodeContainer');
  if (qrContainer) {
    const qrisString = paymentData?.meta?.qrisString;
    const qrisUrl = paymentData?.meta?.qrisUrl;
    if (qrisString && window.QRCodeStyling) {
      const qrCode = new QRCodeStyling({
        width: 250,
        height: 250,
        data: qrisString,
        dotsOptions: { color: '#000', type: 'rounded' },
      });
      qrCode.append(qrContainer);
    } else if (qrisUrl) {
      const img = document.createElement('img');
      img.src = qrisUrl;
      img.style.width = '250px';
      qrContainer.appendChild(img);
    } else {
      qrContainer.textContent = method === 'EWALLET' ? 'Silakan selesaikan pembayaran di aplikasi e-wallet Anda.' : 'QR tidak tersedia.';
    }
  }

  function updateCountdown() {
    const now = Date.now();
    const distance = expiredAt - now;
    if (distance <= 0) {
      if (expEl) expEl.textContent = 'EXPIRED';
      if (alertOverlay) alertOverlay.classList.remove('d-none');
      return;
    }
    const minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
    const seconds = Math.floor((distance % (1000 * 60)) / 1000);
    if (expEl) expEl.textContent = `${minutes} Menit ${seconds} Detik`;
  }

  updateCountdown();
  setInterval(updateCountdown, 1000);

  async function cancelDeposit() {
    const proceed = async () => {
      try {
        await apiFetch(`/api/payments/${encodeURIComponent(paymentId)}/cancel`, {
          method: 'POST',
        });
        if (statusBox) statusBox.textContent = 'CANCELED';
        if (cancelBtn) cancelBtn.remove();
        setTimeout(() => {
          window.location.href = 'home.html';
        }, 1000);
        if (window.Swal) {
          Swal.fire({
            icon: 'success',
            title: 'Deposit dibatalkan',
            text: 'Transaksi deposit berhasil dibatalkan.',
          });
        } else {
          alert('Deposit berhasil dibatalkan.');
        }
      } catch (err) {
        if (window.Swal) {
          Swal.fire({
            icon: 'error',
            title: 'Gagal membatalkan',
            text: err.message || 'Tidak bisa membatalkan deposit.',
          });
        } else {
          alert(err.message || 'Tidak bisa membatalkan deposit.');
        }
      }
    };

    if (window.Swal) {
      Swal.fire({
        icon: 'warning',
        title: 'Batalkan deposit?',
        text: 'Transaksi yang dibatalkan tidak dapat diproses ulang.',
        showCancelButton: true,
        confirmButtonText: 'Batalkan',
        cancelButtonText: 'Kembali',
      }).then((result) => {
        if (result.isConfirmed) proceed();
      });
    } else if (confirm('Batalkan deposit ini?')) {
      proceed();
    }
  }

  if (cancelBtn) {
    cancelBtn.addEventListener('click', cancelDeposit);
  }

  if (alertOverlay) {
    const overlayCard = alertOverlay.querySelector('.aler');
    if (overlayCard) {
      const overlayCancel = document.createElement('div');
      overlayCancel.className = 'btn-konfirm bg-pink';
      overlayCancel.style.marginTop = '16px';
      overlayCancel.textContent = isOrder ? 'Batalkan Pembayaran' : 'Batalkan Deposit';
      overlayCancel.addEventListener('click', cancelDeposit);
      overlayCard.appendChild(overlayCancel);
    }
  }

  async function pollStatus() {
    try {
      const status = await apiFetch(`/api/payments/${encodeURIComponent(paymentId)}/status`);
      const statusText = status?.deposit?.status || status?.order?.status || 'PENDING';
      if (statusBox) {
        statusBox.textContent = statusText;
      }
      if (statusText === 'PAID') {
        if (statusBox) statusBox.textContent = 'Sudah terbayar';
        if (cancelBtn) cancelBtn.remove();
        setTimeout(() => {
          window.location.href = 'transaksi.html';
        }, 1500);
        return;
      }
      if (statusText === 'EXPIRED') {
        if (alertOverlay) alertOverlay.classList.remove('d-none');
        if (cancelBtn) cancelBtn.remove();
        return;
      }
      if (statusText === 'CANCELED') {
        if (cancelBtn) cancelBtn.remove();
        return;
      }
      setTimeout(pollStatus, 3000);
    } catch (err) {
      setTimeout(pollStatus, 5000);
    }
  }

  pollStatus();
})();

function copyIn() {
  const input = document.getElementById('total-bayar');
  if (!input) return;
  input.select();
  try {
    document.execCommand('copy');
    window.getSelection()?.removeAllRanges?.();
  } catch (err) {
    // ignore clipboard errors
  }
}

function goLink(link) {
  if (!link || link.includes('{{')) return;
  window.location.href = link;
}

function generateQRIS() {}
